<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<!-- Generates idex references -->
	<xsl:template name="IndexList">
		<xsl:param name="abc"></xsl:param>
		<xsl:if test="string-length($abc) &gt; 0">
		
			<xsl:variable name="next" select="substring($abc, 3)"></xsl:variable>
			<xsl:variable name="lowerCase" select="substring($abc, 1, 1)"></xsl:variable>
			<xsl:variable name="upperCase" select="substring($abc, 2, 1)"></xsl:variable>

			<xsl:variable name="nodeset" select="//*[not(self::ReturnType)][not(self::Property)][not(self::Parameter)][starts-with(@name, $lowerCase) or starts-with(@name, $upperCase) or starts-with(@elementName, $lowerCase) or starts-with(@elementName, $upperCase)]"></xsl:variable>
			
			<xsl:if test="$nodeset">
				<a href="#_{$upperCase}_"><xsl:value-of select="$upperCase"></xsl:value-of></a>
				<xsl:text> </xsl:text>
			</xsl:if>
		
			<xsl:call-template name="IndexList">
				<xsl:with-param name="abc" select="$next"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>


	<xsl:template name="ProcessXML">
		<xsl:param name="abc"></xsl:param>
		<xsl:if test="string-length($abc) &gt; 0">
		
			<xsl:variable name="next" select="substring($abc, 3)"></xsl:variable>
			<xsl:variable name="lowerCase" select="substring($abc, 1, 1)"></xsl:variable>
			<xsl:variable name="upperCase" select="substring($abc, 2, 1)"></xsl:variable>

			<xsl:variable name="nodeset" select="//*[not(self::ReturnType)][not(self::Property)][not(self::Parameter)][starts-with(@name, $lowerCase) or starts-with(@name, $upperCase) or starts-with(@elementName, $lowerCase) or starts-with(@elementName, $upperCase)]"></xsl:variable>
			
			<xsl:if test="$nodeset">
				<!-- Process char sequence -->

					<a name="_{$upperCase}_"></a>
					<h2><b><xsl:value-of select="$upperCase"></xsl:value-of></b></h2>
					<dl>

					<xsl:for-each select="$nodeset">
						<xsl:sort select="@name"></xsl:sort>
						<xsl:if test="@name">

							<xsl:variable name="shortdescription">
								<xsl:call-template name="createShortElementDescription">
									<xsl:with-param name="element" select="current()"></xsl:with-param>
								</xsl:call-template>
							</xsl:variable>
							<xsl:if test="string-length($shortdescription) &gt; 0">
								<dt>
								<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>
								<xsl:value-of select="$shortdescription"/>
								</dt>
								<!-- Print description -->
								<dd>

								<xsl:apply-templates select="current()" mode="getDescription"></xsl:apply-templates>

								</dd>
								<p/>
							</xsl:if>

						</xsl:if>
					</xsl:for-each>

					<xsl:for-each select="$nodeset">
						<xsl:sort select="@elementName"></xsl:sort>
						<xsl:if test="@elementName">
							

							<dt>

							<xsl:apply-templates select="current()" mode="HRefWithImgLoad"/>
							<xsl:call-template name="createShortElementDescription">
								<xsl:with-param name="element" select="current()"></xsl:with-param>
							</xsl:call-template>

							</dt>

							<!-- Print description -->
							<dd>

							<xsl:apply-templates select="current()" mode="getDescription"></xsl:apply-templates>

							</dd>
							<p/>

						</xsl:if>
					</xsl:for-each>
					</dl>
					<hr/>
			</xsl:if>
		
			<xsl:call-template name="ProcessXML">
				<xsl:with-param name="abc" select="$next"></xsl:with-param>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<!-- Creates short description of elements -->
	<xsl:template name="createShortElementDescription">
		<xsl:param name="element"></xsl:param>
		<xsl:variable name="localName" select="local-name($element)"></xsl:variable>
		
		<xsl:choose>
			<!-- Package -->
			<xsl:when test="$localName='Package'">
				<xsl:variable name="parent" select="$element/.."></xsl:variable>
				<xsl:variable name="parentName" select="$parent/@name"></xsl:variable>
				<xsl:choose>
					<xsl:when test="string-length($parentName) &gt; 0">
						
						<xsl:variable name="refpath">
							<xsl:apply-templates select="$parent" mode="HRefWithImgLoad"/>
						</xsl:variable>

						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'package_in'"></xsl:with-param>
							<xsl:with-param name="p1" select="$element/@name"></xsl:with-param>
							<xsl:with-param name="p2" select="$refpath"></xsl:with-param>
						</xsl:call-template>

					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'package_n'"></xsl:with-param>
							<xsl:with-param name="p1" select="$element/@name"></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Diagram -->
			<xsl:when test="$localName='Diagram'">
				<xsl:variable name="parent" select="$element/.."></xsl:variable>
				<xsl:variable name="parentName" select="$parent/@name"></xsl:variable>
				<xsl:variable name="metaclass" select="$element/@metaclass"></xsl:variable>
				<xsl:choose>
					<xsl:when test="string-length($parentName) &gt; 0">
						<xsl:variable name="refpath">
							<xsl:apply-templates select="$parent" mode="HRefWithImgLoad"/>
						</xsl:variable>

						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'diagram_in'"></xsl:with-param>
							<xsl:with-param name="p1" select="$metaclass"></xsl:with-param>
							<xsl:with-param name="p2" select="$refpath"></xsl:with-param>
						</xsl:call-template>

					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'diagram_n'"></xsl:with-param>
							<xsl:with-param name="p1" select="$metaclass"></xsl:with-param>
							<xsl:with-param name="p2" select="$element/@name"></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<!-- DesignElement -->
			<xsl:when test="$localName='DesignElement'">
				<xsl:choose>
					<xsl:when test="$viewType='diagram'">
						<xsl:variable name="name" select="string($element/@name)"></xsl:variable>
						<xsl:variable name="metaclass" select="string($element/@metaclass)"></xsl:variable>
						<xsl:variable name="id" select="string($element/@id)"></xsl:variable>
						<!--xsl:variable name="diagram" select="$element/../Diagram/DiagramReference[@element=$id]/.."></xsl:variable-->
						<!--xsl:variable name="diagram" select="//Diagram/DiagramReference[@element=$id]/.."></xsl:variable-->
						<xsl:variable name="diagram" select="(//DiagramReference[@element=$id]/ancestor::Diagram)[position()=last()]"/>
						<xsl:if test="string-length($diagram) &gt; 0">
							<xsl:variable name="refpath">
								<xsl:apply-templates select="$diagram" mode="HRefWithImgLoad"/>
							</xsl:variable>

							<xsl:call-template name="getLocalizedResource">
								<xsl:with-param name="code" select="'design_in'"></xsl:with-param>
								<xsl:with-param name="p1" select="$metaclass"></xsl:with-param>
								<xsl:with-param name="p2" select="$diagram/@metaclass"></xsl:with-param>
								<xsl:with-param name="p3" select="$refpath"></xsl:with-param>
							</xsl:call-template>
						</xsl:if>
					</xsl:when>
					<xsl:otherwise>
						<!-- $viewType="'model'"-->
						<xsl:variable name="name" select="string($element/@name)"></xsl:variable>
						<xsl:variable name="metaclass" select="string($element/@metaclass)"></xsl:variable>
						<xsl:variable name="id" select="string($element/@id)"></xsl:variable>
						<xsl:variable name="package" select="($element/ancestor::Package | $element/ancestor::Model)[position()=last()]"/>

						<xsl:variable name="refpath">
							<xsl:apply-templates select="$package" mode="HRefWithImgLoad"/>
						</xsl:variable>
						
						<xsl:variable name="packagetext">
							<xsl:choose>
								<xsl:when test="local-name($package)='Model'">
									<xsl:value-of select="''"/>
								</xsl:when>
								<xsl:otherwise>
									<xsl:call-template name="getLocalizedResource">
										<xsl:with-param name="code" select="'Package_1'"/>
									</xsl:call-template>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:variable>

						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'design_in'"></xsl:with-param>
							<xsl:with-param name="p1" select="$metaclass"></xsl:with-param>
							<xsl:with-param name="p2" select="$packagetext"></xsl:with-param>
							<xsl:with-param name="p3" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<!-- Field -->
			<xsl:when test="$localName='Field'">
				<xsl:variable name="name" select="string($element/@elementName)"></xsl:variable>
				<xsl:variable name="class" select="$element/.."></xsl:variable>
				<xsl:variable name="refpath">
					<xsl:apply-templates select="$class" mode="HRefWithImgLoad"/>
				</xsl:variable>

				<xsl:variable name="fcode">
					<xsl:choose>
						<xsl:when test="$element/@fieldType='Port'">
							<xsl:value-of select="'port_in'"/>
						</xsl:when>
						<xsl:when test="$element/@fieldType='Part'">
							<xsl:value-of select="'part_in'"/>
						</xsl:when>
						<xsl:when test="$element/@fieldType='Coll'">
							<xsl:value-of select="'coll_in'"/>
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of select="'field_in'"/>
						</xsl:otherwise>
					</xsl:choose>
				</xsl:variable>
				<xsl:choose>
					<xsl:when test="$class/@type='Class'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="concat($fcode, '_class')"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
						</xsl:call-template>					
					</xsl:when>
					<xsl:when test="$class/@type='Interface'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="concat($fcode, '_interface')"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$class/@type='Struct'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="concat($fcode, '_struct')"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$class/@type='Enum'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="concat($fcode, '_enum')"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$class/@type='Delegate'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="concat($fcode, '_delegate')"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$class/@type='Module'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="concat($fcode, '_module')"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
					</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>

						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="$fcode"></xsl:with-param>
							<xsl:with-param name="p1" select="$class/@type"></xsl:with-param>
							<xsl:with-param name="p2" select="$refpath"></xsl:with-param>
						</xsl:call-template>

                			</xsl:otherwise>
				</xsl:choose>
			
			</xsl:when>

			<!-- Method -->
			<xsl:when test="$localName='Method'">
				<xsl:variable name="class" select="$element/.."></xsl:variable>
				
				<xsl:variable name="refpath">
					<xsl:apply-templates select="$class" mode="HRefWithImgLoad"/>
				</xsl:variable>

				<xsl:choose>
					<xsl:when test="$class/@type='Class'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'method_in_class'"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
						</xsl:call-template>					
					</xsl:when>
					<xsl:when test="$class/@type='Interface'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'method_in_interface'"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$class/@type='Struct'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'method_in_struct'"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$class/@type='Enum'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'method_in_enum'"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$class/@type='Delegate'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'method_in_delegate'"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
						</xsl:call-template>
					</xsl:when>
					<xsl:when test="$class/@type='Module'">
						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'method_in_module'"/>
							<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
					</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>

						<xsl:call-template name="getLocalizedResource">
							<xsl:with-param name="code" select="'method_in'"></xsl:with-param>
							<xsl:with-param name="p1" select="$class/@type"></xsl:with-param>
							<xsl:with-param name="p2" select="$refpath"></xsl:with-param>
						</xsl:call-template>

                			</xsl:otherwise>
				</xsl:choose>
			</xsl:when>
			
			<!-- Model -->
			<xsl:when test="$localName='Model'">
				<xsl:call-template name="getLocalizedResource">
					<xsl:with-param name="code" select="'root_package'"></xsl:with-param>
				</xsl:call-template>
			</xsl:when>

			<!--Classifier -->
			<xsl:otherwise>
				<xsl:variable name="parent" select="$element/.."></xsl:variable>
				<xsl:variable name="parentName" select="$parent/@name"></xsl:variable>
				<xsl:choose>
					<xsl:when test="string-length($parentName) &gt; 0">

						<xsl:variable name="refpath">
							<xsl:apply-templates select="$parent" mode="HRefWithImgLoad"/>
						</xsl:variable>

						<xsl:choose>
							<xsl:when test="$element/@type='Class'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'class_in'"/>
									<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
								</xsl:call-template>					
							</xsl:when>
							<xsl:when test="$element/@type='Interface'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'interface_in'"/>
									<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="$element/@type='Struct'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'struct_in'"/>
									<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="$element/@type='Enum'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'enum_in'"/>
									<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="$element/@type='Delegate'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'delegate_in'"/>
									<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="$element/@type='Module'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'module_in'"/>
									<xsl:with-param name="p1" select="$refpath"></xsl:with-param>
							</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'classifier_in'"></xsl:with-param>
									<xsl:with-param name="p1" select="$element/@type"></xsl:with-param>
									<xsl:with-param name="p2" select="$refpath"></xsl:with-param>
								</xsl:call-template>
                					</xsl:otherwise>
						</xsl:choose>
                        
	

					</xsl:when>
					<xsl:otherwise>

						<xsl:choose>
							<xsl:when test="$element/@type='Class'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'class_n'"/>
									<xsl:with-param name="p1" select="$element/@name"></xsl:with-param>
								</xsl:call-template>					
							</xsl:when>
							<xsl:when test="$element/@type='Interface'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'interface_n'"/>
									<xsl:with-param name="p1" select="$element/@name"></xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="$element/@type='Struct'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'struct_n'"/>
									<xsl:with-param name="p1" select="$element/@name"></xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="$element/@type='Enum'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'enum_n'"/>
									<xsl:with-param name="p1" select="$element/@name"></xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="$element/@type='Delegate'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'delegate_n'"/>
									<xsl:with-param name="p1" select="$element/@name"></xsl:with-param>
								</xsl:call-template>
							</xsl:when>
							<xsl:when test="$element/@type='Module'">
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'module_n'"/>
									<xsl:with-param name="p1" select="$element/@name"></xsl:with-param>
							</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<xsl:call-template name="getLocalizedResource">
									<xsl:with-param name="code" select="'classifier_n'"></xsl:with-param>
									<xsl:with-param name="p1" select="$element/@type"></xsl:with-param>
									<xsl:with-param name="p2" select="$element/@name"></xsl:with-param>
								</xsl:call-template>
                   					</xsl:otherwise>
						</xsl:choose>

					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
			
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
